<?php
/* -----------------------------------------------------------------
 * 	$Id: paypal_config.php 1548 2016-04-06 13:03:10Z akausch $
 * 	Copyright (c) 2011-2021 commerce:SEO by Webdesign Erfurt
 * 	http://www.commerce-seo.de
 * ------------------------------------------------------------------
 * 	based on:
 * 	modified eCommerce Shopsoftware
 * 	http://www.modified-shop.org
 * 	Copyright (c) 2009 - 2013 [www.modified-shop.org]
 * 	(c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
 * 	(c) 2002-2003 osCommerce - www.oscommerce.com
 * 	(c) 2003     nextcommerce - www.nextcommerce.org
 * 	(c) 2005     xt:Commerce - www.xt-commerce.com
 * 	Released under the GNU General Public License
 * --------------------------------------------------------------- */


require('includes/application_top.php');
require_once(DIR_FS_EXTERNAL.'paypal/classes/PayPalAdmin.php');
$paypal = new PayPalAdmin();

if (isset($_GET['action'])) {
  switch ($_GET['action']) {
    case 'update':
      $sql_data_array = array();
      foreach ($_POST['config'] as $key => $value) {
        $sql_data_array[] = array(
          'config_key' => $key,
          'config_value' => $value,
        );
      }
      $paypal->save_config($sql_data_array);
      xtc_redirect(xtc_href_link('paypal_config.php'));
      break;
      
    case 'status_install':
      $paypal->status_install();
      xtc_redirect(xtc_href_link('paypal_config.php'));
      break;
  }
}

$orders_statuses = array(array('id' => '-1', 'text' => TEXT_PAYPAL_NO_STATUS_CHANGE));
$orders_status_query = xtc_db_query("SELECT orders_status_id,
                                            orders_status_name
                                       FROM ".TABLE_ORDERS_STATUS."
                                      WHERE language_id = '".$_SESSION['languages_id']."'
                                   ORDER BY sort_order");
while ($orders_status = xtc_db_fetch_array($orders_status_query)) {
  $orders_statuses[] = array ('id' => $orders_status['orders_status_id'], 'text' => $orders_status['orders_status_name']);
}

$status_array = array(
  array('id' => 1, 'text' => YES),
  array('id' => 0, 'text' => NO),
); 

$mode_array = array(
  array('id' => 'live', 'text' => 'Live'),
  array('id' => 'sandbox', 'text' => 'Sandbox'),
); 

$transaction_array = array(
  array('id' => 'sale', 'text' => 'Sale'),
  array('id' => 'authorize', 'text' => 'Authorize'),
); 

$log_level_array = array(
  array('id' => 'ERROR', 'text' => 'Error'),
  array('id' => 'WARN', 'text' => 'Warning'),
  array('id' => 'INFO', 'text' => 'Info'),
  array('id' => 'FINE', 'text' => 'Fine'),
  array('id' => 'DEBUG', 'text' => 'Debug'),
); 

require_once(DIR_WS_INCLUDES.'header.php');
?>
<link rel="stylesheet" type="text/css" href="../includes/external/paypal/css/stylesheet.css">  
<table class="table table-striped table-bordered">
	<tr>
		<th colspan="5"><?php echo TEXT_PAYPAL_CONFIG_HEADING_TITLE; ?></th>
	</tr>
	<tr>
	  <?php
		echo '<td><a href="'.xtc_href_link('paypal_config.php', '', 'SSL').'">'.TEXT_PAYPAL_TAB_CONFIG.'</a></td>';
		echo '<td><a href="'.xtc_href_link('paypal_profile.php', '', 'SSL').'">'.TEXT_PAYPAL_TAB_PROFILE.'</a></td>';
		echo '<td><a href="'.xtc_href_link('paypal_webhook.php', '', 'SSL').'">'.TEXT_PAYPAL_TAB_WEBHOOK.'</a></td>';
		echo '<td><a href="'.xtc_href_link('paypal_module.php', '', 'SSL').'">'.TEXT_PAYPAL_TAB_MODULE.'</a></td>';
		echo '<td><a href="'.xtc_href_link('paypal_payment.php', '', 'SSL').'">'.TEXT_PAYPAL_TAB_TRANSACTIONS.'</a></td>';
	  ?>
	</tr>
</table>
  <?php 
	echo xtc_draw_form('config', 'paypal_config.php', xtc_get_all_get_params(array('action')).'action=update');
  ?>

<table class="table table-striped table-bordered">
  <tr>
	<td><?php echo TEXT_PAYPAL_CONFIG_CLIENT_LIVE; ?></td>
	<td><?php echo xtc_draw_input_field('config[PAYPAL_CLIENT_ID_LIVE]', $paypal->get_config('PAYPAL_CLIENT_ID_LIVE'), 'style="width: 300px;"'); ?></td>
	<td><?php echo TEXT_PAYPAL_CONFIG_CLIENT_LIVE_INFO; ?></td>
  </tr>
  <tr>
	<td><?php echo TEXT_PAYPAL_CONFIG_SECRET_LIVE; ?></td>
	<td><?php echo xtc_draw_input_field('config[PAYPAL_SECRET_LIVE]', $paypal->get_config('PAYPAL_SECRET_LIVE'), 'style="width: 300px;"'); ?></td>
	<td><?php echo TEXT_PAYPAL_CONFIG_SECRET_LIVE_INFO; ?></td>
  </tr>
  <tr>
	<td><?php echo TEXT_PAYPAL_CONFIG_CLIENT_SANDBOX; ?></td>
	<td><?php echo xtc_draw_input_field('config[PAYPAL_CLIENT_ID_SANDBOX]', $paypal->get_config('PAYPAL_CLIENT_ID_SANDBOX'), 'style="width: 300px;"'); ?></td>
	<td><?php echo TEXT_PAYPAL_CONFIG_CLIENT_SANDBOX_INFO; ?></td>
  </tr>
  <tr>
	<td><?php echo TEXT_PAYPAL_CONFIG_SECRET_SANDBOX; ?></td>
	<td><?php echo xtc_draw_input_field('config[PAYPAL_SECRET_SANDBOX]', $paypal->get_config('PAYPAL_SECRET_SANDBOX'), 'style="width: 300px;"'); ?></td>
	<td><?php echo TEXT_PAYPAL_CONFIG_SECRET_SANDBOX_INFO; ?></td>
  </tr>
  <tr>
	<td><?php echo TEXT_PAYPAL_CONFIG_MODE; ?></td>
	<td><?php echo xtc_draw_pull_down_menu('config[PAYPAL_MODE]', $mode_array, $paypal->get_config('PAYPAL_MODE')); ?></td>
	<td><?php echo TEXT_PAYPAL_CONFIG_MODE_INFO; ?></td>
  </tr>
  <tr>
	<td><?php echo TEXT_PAYPAL_CONFIG_INVOICE_PREFIX; ?></td>
	<td><?php echo xtc_draw_input_field('config[PAYPAL_CONFIG_INVOICE_PREFIX]', $paypal->get_config('PAYPAL_CONFIG_INVOICE_PREFIX'), 'style="width: 300px;"'); ?></td>
	<td><?php echo TEXT_PAYPAL_CONFIG_INVOICE_PREFIX_INFO; ?></td>
  </tr>
  <tr>
	<td><?php echo TEXT_PAYPAL_CONFIG_TRANSACTION; ?></td>
	<td><?php echo xtc_draw_pull_down_menu('config[PAYPAL_TRANSACTION_TYPE]', $transaction_array, $paypal->get_config('PAYPAL_TRANSACTION_TYPE')); ?></td>
	<td><?php echo TEXT_PAYPAL_CONFIG_TRANSACTION_INFO; ?></td>
  </tr>
  <tr>
	<td><?php echo TEXT_PAYPAL_CONFIG_CAPTURE; ?></td>
	<td><?php echo draw_on_off_selection('config[PAYPAL_CAPTURE_MANUELL]', $status_array, $paypal->get_config('PAYPAL_CAPTURE_MANUELL')); ?></td>
	<td><?php echo TEXT_PAYPAL_CONFIG_CAPTURE_INFO; ?></td>
  </tr>
  <tr>
	<td><?php echo TEXT_PAYPAL_CONFIG_CART; ?></td>
	<td><?php echo draw_on_off_selection('config[PAYPAL_ADD_CART_DETAILS]', $status_array, (($paypal->get_config('PAYPAL_ADD_CART_DETAILS') == 1) ? true : false)); ?></td>
	<td><?php echo TEXT_PAYPAL_CONFIG_CART_INFO; ?></td>
  </tr>
  <tr>
	<td><?php echo TEXT_PAYPAL_CONFIG_STATE_SUCCESS; ?></td>
	<td><?php echo xtc_draw_pull_down_menu('config[PAYPAL_ORDER_STATUS_SUCCESS_ID]', $orders_statuses, $paypal->get_config('PAYPAL_ORDER_STATUS_SUCCESS_ID')); ?></td>
	<td><?php echo TEXT_PAYPAL_CONFIG_STATE_SUCCESS_INFO; ?></td>
  </tr>
  <tr>
	<td><?php echo TEXT_PAYPAL_CONFIG_STATE_REJECTED; ?></td>
	<td><?php echo xtc_draw_pull_down_menu('config[PAYPAL_ORDER_STATUS_REJECTED_ID]', $orders_statuses, $paypal->get_config('PAYPAL_ORDER_STATUS_REJECTED_ID')); ?></td>
	<td><?php echo TEXT_PAYPAL_CONFIG_STATE_REJECTED_INFO; ?></td>
  </tr>
  <tr>
	<td><?php echo TEXT_PAYPAL_CONFIG_STATE_PENDING; ?></td>
	<td><?php echo xtc_draw_pull_down_menu('config[PAYPAL_ORDER_STATUS_PENDING_ID]', $orders_statuses, $paypal->get_config('PAYPAL_ORDER_STATUS_PENDING_ID')); ?></td>
	<td><?php echo TEXT_PAYPAL_CONFIG_STATE_PENDING_INFO; ?></td>
  </tr>
  <tr>
	<td><?php echo TEXT_PAYPAL_CONFIG_STATE_TEMP; ?></td>
	<td><?php echo xtc_draw_pull_down_menu('config[PAYPAL_ORDER_STATUS_TMP_ID]', $orders_statuses, $paypal->get_config('PAYPAL_ORDER_STATUS_TMP_ID')); ?></td>
	<td><?php echo TEXT_PAYPAL_CONFIG_STATE_TEMP_INFO; ?></td>
  </tr>
  <tr>
	<td><?php echo TEXT_PAYPAL_CONFIG_STATE_CAPTURED; ?></td>
	<td><?php echo xtc_draw_pull_down_menu('config[PAYPAL_ORDER_STATUS_CAPTURED_ID]', $orders_statuses, $paypal->get_config('PAYPAL_ORDER_STATUS_CAPTURED_ID')); ?></td>
	<td><?php echo TEXT_PAYPAL_CONFIG_STATE_CAPTURED_INFO; ?></td>
  </tr>
  <tr>
	<td><?php echo TEXT_PAYPAL_CONFIG_STATE_REFUNDED; ?></td>
	<td><?php echo xtc_draw_pull_down_menu('config[PAYPAL_ORDER_STATUS_REFUNDED_ID]', $orders_statuses, $paypal->get_config('PAYPAL_ORDER_STATUS_REFUNDED_ID')); ?></td>
	<td><?php echo TEXT_PAYPAL_CONFIG_STATE_REFUNDED_INFO; ?></td>
  </tr>
  <tr>
	<td><?php echo TEXT_PAYPAL_CONFIG_LOG; ?></td>
	<td><?php echo draw_on_off_selection('config[PAYPAL_LOG_ENALBLED]', $status_array, (($paypal->get_config('PAYPAL_LOG_ENALBLED') == 1) ? true : false)); ?></td>
	<td><?php echo TEXT_PAYPAL_CONFIG_LOG_INFO; ?></td>
  </tr>
  <tr>
	<td><?php echo TEXT_PAYPAL_CONFIG_LOG_LEVEL; ?></td>
	<td><?php echo xtc_draw_pull_down_menu('config[PAYPAL_LOG_LEVEL]', $log_level_array, $paypal->get_config('PAYPAL_LOG_LEVEL')); ?></td>
	<td><?php echo TEXT_PAYPAL_CONFIG_LOG_LEVEL_INFO; ?></td>
  </tr>
  <tr>
	<td class="text-left">
	  <a class="btn btn-info btn-sm" href="<?php echo xtc_href_link('paypal_config.php', 'action=status_install'); ?>"><?php echo BUTTON_PAYPAL_STATUS_INSTALL; ?></a>
	</td>
	<td class="text-right" colspan="2">
	  <input type="submit" class="btn btn-info btn-sm" name="submit" value="<?php echo BUTTON_UPDATE; ?>">
	</td>
  </tr>
</table>
</form>
<?php 
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');
